<?php 
/* 
 * Instagram API Class 
 * This class helps to authenticate with Instagram API 
 * @author     Phpsof.com 
 * @url        http://www.Phpsof.com 
 * @license    http://www.Phpsof.com/license 
 */ 
class InstagramAuth { 
    public $client_id               = ''; 
    public $client_secret           = ''; 
    public $redirect_url            = ''; 
    private $act_url                = 'https://api.instagram.com/oauth/access_token'; 
    private $tkon_long_lived_url    = 'https://graph.instagram.com/access_token';
    private $refresh_tkon_url       = 'https://graph.instagram.com/refresh_access_token';
    private $ud_url                 = 'https://graph.instagram.com/me/media'; 
    private $media_url              = 'https://graph.instagram.com/';
    private $user_info              = 'https://graph.instagram.com/me';
     
    public function __construct(array $config = array()){ 
        $this->initialize($config); 
    } 
     
    public function initialize(array $config = array()){ 
        foreach ($config as $key => $val){ 
            if (isset($this->$key)){ 
                $this->$key = $val; 
            } 
        } 
        return $this; 
    }
     
    public function getAuthURL(){ 
        $authURL = "https://api.instagram.com/oauth/authorize/?client_id=" . $this->client_id . "&redirect_uri=" . urlencode($this->redirect_url) . "&response_type=code&scope=user_profile,user_media";
        return $authURL; 
    } 
     
    public function getAccessToken($code) {     
        // return 'IGQVJVRjBqRm9RNmNITC1aTy1UWXR2YmR1WW56cDYyMkxvekdCOHN5OVlTUzBaRUJ6VEFPMmJIN1VtTUJLVXpsTk5hcHFleVVPZADBWc1dmd1FVZATdTY0Rydk5WRTc5TUVlYmZAxXzRR';
        $urlPost = '&client_id='. $this->client_id . '&client_secret=' . $this->client_secret . '&redirect_uri=' . $this->redirect_url . '&code='. $code . '&grant_type=authorization_code'; 
        $ch = curl_init();         
        curl_setopt($ch, CURLOPT_URL, $this->act_url);         
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
        curl_setopt($ch, CURLOPT_POST, 1);         
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE); 
        curl_setopt($ch, CURLOPT_POSTFIELDS, $urlPost);             
        $data = json_decode(curl_exec($ch), true);     
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);     
        curl_close($ch); 
        
        
        if($http_code != '200'){     
            throw new Exception('Error : Failed to receive access token'.$http_code); 
        } 
        
        return $data;     
    } 
    
    public function get_access_token_long_lived($access_token){
        $urlPost = $this->tkon_long_lived_url.'?grant_type=ig_exchange_token&client_secret='.$this->client_secret.'&access_token='.$access_token;  
        $data = $this->callInstagram($urlPost);
        return $data['access_token'];
    }
    
    public function refresh_access_token($access_token, $access_token_ ){
        $urlPost = $this->refresh_tkon_url.'?grant_type=ig_refresh_token&access_token='.$access_token;  
        $data = $this->callInstagram($urlPost);
        
        if($data == null){
            $token = $this->get_access_token_long_lived($access_token_);
            return $token;
        }else{
            return $data['access_token'];
        }
    }
    
    public function getUserInfo($access_token) {  
        $urlPost = $this->user_info.'?fields=id,username&access_token=' . $access_token;  
        $data = $this->callInstagram($urlPost);
        return $data; 
    }
 
    public function getUserMediaIds($access_token) {  
        $urlPost = $this->ud_url.'?fields=id,caption&access_token=' . $access_token;  
        $data = $this->callInstagram($urlPost);
        $data_media = $data['data'];
        return $data_media; 
    }
    
    
    public function getUserMediacontents($userMediaIds, $access_token) {  
        $data_contents_media = array();
        foreach ($userMediaIds as $key => $value){
            
            $urlPost = $this->media_url.$value['id'].'?fields=id,media_type,media_url,username,timestamp&access_token='.$access_token;
            $data = $this->callInstagram($urlPost);
            array_push($data_contents_media, $data);
            
        }
        return $data_contents_media; 
    }
    
    
    public function callInstagram($url)
    {
        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => 2
        ));
        $result = json_decode(curl_exec($ch), true); 
        curl_close($ch);
        return $result;
    }
}