<?php 
// Include configuration file 
require_once 'config.php'; 
 
// Include User class 
require_once 'User.class.php'; 
 
// If URL contains 'code' parameter that passed by Instagram in the Redirect URL 
$user_id = 19767;
$access_token = '';

if(isset($_GET['code'])){ 
    
    try { 
        // Get the access token  
        $data_token = $instagram->getAccessToken($_GET['code']); 
        
        //check if user already exsist
        $user = new User(); 
        $intUserData = array(); 
        $intUserData['oauth_uid']        = $data_token['user_id']; 
        $intUserData['oauth_provider']  = 'instagram'; 
        $intUserData['user_id']         = $user_id; 
        
        $checkexsistuser = $user->checkExsistUser($intUserData);
        if($checkexsistuser == false){
            // Refresh a long-lived token
            $access_token = $instagram->get_access_token_long_lived($data_token['access_token']); 
        }else{
            // Refresh a long-lived token
            $access_token = $instagram->refresh_access_token($checkexsistuser['token'], $data_token['access_token']); 
        }
        
        
    } catch (Exception $e) { 
        $authErr = $e->getMessage(); 
    } 
     
    
}else{ 
    // Get login url 
    $authURL = $instagram->getAuthURL();
    // Render Instagram login button 
    $output = '<a href="'.htmlspecialchars($authURL).'" class="instagram-btn"><span class="btn-icon"></span><span class="btn-text">Login with Instagram</span></a>'; 
} 
?>


<!doctype html>
<html lang="en" class="no-js">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="stylesheet" href="css/reset.css"> <!-- CSS reset -->
		<link rel="stylesheet" href="css/style.css"> <!-- Resource style -->
		<script src="js/modernizr.js"></script> <!-- Modernizr -->
		
		<title>login successfully, popup will close automatically</title>
	</head>
	<body>
		<div class="cd-slider-wrapper">
			Login successfully, popup will close automatically
		</div> <!-- .cd-slider-wrapper -->
    	<script src="js/jquery-2.1.4.js"></script>
    	<script src="js/jquery.mobile.custom.min.js"></script>
    	<script>
    	$( document ).ready(function() {
              // Handler for .ready() called.
              window.opener.postMessage("<?php echo $access_token ?>", "*");
              window.close();
        });
    	    
    	</script>
    	
	</body>
	

</html>