<?php 
// Include configuration file 
require_once 'config.php'; 
 
// Include User class 
require_once 'User.class.php'; 
 
// If URL contains 'code' parameter that passed by Instagram in the Redirect URL 
if(isset($_GET['code'])){ 
    try { 
        // Get the access token  
        $access_token = $instagram->getAccessToken($_GET['code']); 
        // Get user Info 
        $userInfo = $instagram->getUserInfo($access_token); 
        // Get user Medias ids 
        $userMediaIds = $instagram->getUserMediaIds($access_token); 
        // Get user Medias contents 
        $userMediaContents = $instagram->getUserMediacontents($userMediaIds, $access_token); 
        
    } catch (Exception $e) { 
        $authErr = $e->getMessage(); 
    } 
     
    if(!empty($userMediaContents) && !empty($userInfo)){
        $output = '';
        foreach ($userMediaContents as $key => $val){
            $output = $output.'<div class="box">'.
                  '<div class="boxInner" style="background-image: url(\''.$val['media_url'].'\'); background-size: cover; background-position: center center; height: 100%; width: 100%;">'.
                  '</div>'.
                '</div>';
        }
        $username = $userInfo['username'];
        
        
    }else{ 
        $output = '<h3 style="color:red">Instagram authentication has failed!</h3>'; 
        if(!empty($authErr)){ 
            $output = '<p style="color:red">'.$authErr.'</p>'; 
        } 
    } 
}else{ 
    // Get login url 
    $authURL = $instagram->getAuthURL(); 
     
    // Render Instagram login button 
    $output = '<a href="'.htmlspecialchars($authURL).'" class="instagram-btn"><span class="btn-icon"></span><span class="btn-text">Login with Instagram</span></a>'; 
} 
?>





<!DOCTYPE html>
<html lang="en">
    <head>
        <title>medias instagram grids</title>
        <meta charset="utf-8">
        <link rel="stylesheet" href="css/style.css">
        <style>
        
            .box {
              float: left;
              position: relative;
              width: 20%;
              padding-bottom: 20%;
            }
            
            .boxInner {
              position: absolute;
              left: 10px;
              right: 10px;
              top: 10px;
              bottom: 10px;
              overflow: hidden;
            }
            
            .box {
                width: 24.5%;
                height: 2vh;;
                margin: 0 0.5% 0.5% 0;
            }
        
            .title {
                position: static;
                height: 55px;
                width: 100%;
                text-align: center;
                margin: auto;
                display: flex!important;
                align-items: center;
                justify-content: center;
            }
        
            .title {
                color: #125688;
                font-size: 3vh;
                display: none;
            }
        
            .title .username {
                margin: 0 0 0 15px;
            }
    
        </style>
    </head>
    <body>
        <section class="no-touch">
        
            <div class='slick-slider'>
            
                <?php echo $output; ?>
            
            </div>
            <div class="title color-text-heading"><p class="username">@<?php echo $username; ?></p></div>
          
        </section>
        
    </body>
</html>