<?php 
// Include configuration file 
require_once 'config.php'; 
 
// Include User class 
require_once 'User.class.php'; 
 
// If URL contains 'code' parameter that passed by Instagram in the Redirect URL 
$user_id = 19767;
if(isset($_GET['code'])){ 
    try { 
        // Get the access token  
        $data_token = $instagram->getAccessToken($_GET['code']); 
        
        //check if user already exsist
        $user = new User(); 
        $intUserData = array(); 
        $intUserData['oauth_uid']        = $data_token['user_id']; 
        $intUserData['oauth_provider']  = 'instagram'; 
        $intUserData['user_id']         = $user_id; 
        
        $checkexsistuser = $user->checkExsistUser($intUserData);
        if($checkexsistuser == false){
            // Refresh a long-lived token
            $access_token = $instagram->get_access_token_long_lived($data_token['access_token']); 
        }else{
            // Refresh a long-lived token
            $access_token = $instagram->refresh_access_token($checkexsistuser['token'], $data_token['access_token']); 
        }
        
        
        // Get user Info 
        $userInfo = $instagram->getUserInfo($access_token); 
        
        if(!empty($userInfo)){
        
            // Initialize User class 
            $user = new User(); 
            // Getting user's profile data 
            $intUserData = array(); 
            $intUserData['oauth_uid']       = $data_token['user_id'];
            $intUserData['username']        = $userInfo['username']; 
            $intUserData['token']           = $access_token; 
            $intUserData['oauth_provider']  = 'instagram'; 
            $intUserData['user_id']         = $user_id; 
            // Insert or update user data to the database 
            $userData = $user->checkUser($intUserData); 
        
        }
        // Get user Medias ids 
        $userMediaIds = $instagram->getUserMediaIds($access_token); 
        // Get user Medias contents 
        $userMediaContents = $instagram->getUserMediacontents($userMediaIds, $access_token); 
        
    } catch (Exception $e) { 
        $authErr = $e->getMessage(); 
    } 
     
    if(!empty($userMediaContents) && !empty($userInfo)){
        
        $username = $userInfo['username'];
        $userMediaContent = $userMediaContents[0];
        $output = '<li class="is-visible">
				<div class="cd-half-block content">
					<div class="div_username">
						<p>@'.$userMediaContent['username'].'</p>
						<span>'.
							$userMediaContent['timestamp']
						.'</span>
					</div>
				</div>
				<div class="cd-half-block image" style="background-image: url(\''.$userMediaContent['media_url'].'\');"></div>
			</li> <!-- .cd-half-block.content -->';
        
        
        
    }else{ 
        $output = '<h3 style="color:red">Instagram authentication has failed!</h3>'; 
        if(!empty($authErr)){ 
            $output = '<p style="color:red">'.$authErr.'</p>'; 
        } 
    } 
}else{ 
    // Get login url 
    $authURL = $instagram->getAuthURL(); 
     
    // Render Instagram login button 
    $output = '<a href="'.htmlspecialchars($authURL).'" class="instagram-btn"><span class="btn-icon"></span><span class="btn-text">Login with Instagram</span></a>'; 
} 
?>


<!doctype html>
<html lang="en" class="no-js">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="stylesheet" href="css/reset.css"> <!-- CSS reset -->
		<link rel="stylesheet" href="css/style.css"> <!-- Resource style -->
		<script src="js/modernizr.js"></script> <!-- Modernizr -->
		
		<title>Login with Instagram using PHP by Phpsof</title>
	</head>
	<body>
		<div class="cd-slider-wrapper">
			<ul class="cd-slider">
			    <?php echo  $output; ?>
			</ul> <!-- .cd-slider -->
		</div> <!-- .cd-slider-wrapper -->
	<script src="js/jquery-2.1.4.js"></script>
	<script src="js/jquery.mobile.custom.min.js"></script>
	</body>
	
	<script>
	    
	    $().ready(function(){
	        var userMediaContents = JSON.parse('<?php echo json_encode($userMediaContents); ?>');
            var i = 0;
          
          
            //   pick body element ID
            var media = $('.is-visible .cd-half-block.image');
            var username = $('.is-visible .div_username p');
            var publish_date = $('.is-visible .div_username span')
              
            //   change image every after 5 seconds
              setInterval(function(){
                media.fadeOut(1000, function(){
                  media.css('background-image', 'url(' + userMediaContents[i]['media_url'] +')');
                  username.html('@'+userMediaContents[i]['username']);
                  publish_date.html(userMediaContents[i]['timestamp']);
                  i++;
                  media.fadeIn(1000);
                })
                if(i == userMediaContents.length) i = 0;
              }, 10000)
        })


	</script>
</html>