<?php 
// Include configuration file 
require_once 'config.php'; 
 
// Include User class 
require_once 'User.class.php'; 
 
// If URL contains 'code' parameter that passed by Instagram in the Redirect URL 
if(isset($_GET['token'])){ 
    try { 
        // Get user Medias ids
        $userMediaIds = $instagram->getUserMediaIds($_GET['token']); 
        
        // Get user Medias contents 
        $userMediaContents = $instagram->getUserMediacontents($userMediaIds, $_GET['token']); 
        
        //Get user information
        $userInfo = $instagram->getUserInfo($_GET['token']); 
        
    } catch (Exception $e) { 
        $authErr = $e->getMessage(); 
    } 
     
    if(!empty($userMediaContents) && !empty($userInfo)){
        
        $username = $userInfo['username'];
        
        if(isset($_GET['type_layout']) && ($_GET['type_layout'] == 'single' || $_GET['type_layout'] == 'single-card' )){
            $userMediaContent = $userMediaContents[0];
            $output = '<li class="is-visible">
            				<div class="cd-half-block content">
            					<div class="div_username">
            						<p>@'.$userMediaContent['username'].'</p>
            						<span>'.
            							$userMediaContent['timestamp']
            						.'</span>
            					</div>
            				</div>
            				<div class="cd-half-block image" style="background-image: url(\''.$userMediaContent['media_url'].'\');"></div>
            			</li>';
            
        }elseif(isset($_GET['type_layout'])){
            
            
            $i = 1;
            foreach ($userMediaContents as $key => $val){
                
                
                $output = $output.'<div class="box">'.
                      '<div class="boxInner" style="background-image: url(\''.$val['media_url'].'\'); background-size: cover; background-position: center center; height: 100%; width: 100%;">'.
                      '</div>'.
                    '</div>';
                
                if($i == $_GET['nbr_medias']) break;
                else $i ++;
            }
            $username = $userInfo['username'];
            
        }
        
        
        
        
        
        
    }else{ 
        $output = '<h3 style="color:red">Instagram authentication has failed!</h3>'; 
        if(!empty($authErr)){ 
            $output = '<p style="color:red">'.$authErr.'</p>'; 
        } 
    } 
}else{ 
    // Get login url 
    $authURL = $instagram->getAuthURL(); 
     
    // Render Instagram login button 
    $output = '<a href="'.htmlspecialchars($authURL).'" class="instagram-btn"><span class="btn-icon"></span><span class="btn-text">Login with Instagram</span></a>'; 
} 





if(isset($_GET['type_layout']) && ($_GET['type_layout'] =='single' || $_GET['type_layout'] == 'single-card' )){
    include('medias_type_single.php');
}elseif(isset($_GET['type_layout'])){
    include('medias_type_grid.php');
}else{
    echo 'Error! please choose a valid layout type';
}
?>

